/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWHasParameterDefs;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.util.Hashtable;

public final class VWOperationDefinition
extends VWMLABase
implements Serializable,
IVWHasParameterDefs,
Cloneable {
    private static final long serialVersionUID = 7488L;
    protected String name = null;
    protected String description = null;
    protected VWQueueDefinition myQueue = null;
    private VWParameterDefinition[] parameters = null;
    private VWArrayHandler parametersHandler = new VWArrayHandler();
    protected Hashtable attributes = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:20:35 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/4 $";
    }

    protected VWOperationDefinition(VWQueueDefinition theQueue, String theName) throws VWException {
        if (theQueue == null) {
            throw new VWException("vw.api.VWOperationDefinitionInvalidQueue", "theQueue is invalid, (null).");
        }
        this.myQueue = theQueue;
        this.setName(theName);
    }

    protected VWOperationDefinition(VWQueueDefinition theQueue, String theName, String theDescription) throws VWException {
        if (theQueue == null) {
            throw new VWException("vw.api.VWOperationDefinitionInvalidQueue", "theQueue is invalid, (null).");
        }
        this.myQueue = theQueue;
        this.setName(theName);
        this.setDescription(theDescription);
    }

    public VWParameterDefinition createParameter(String theName, int theMode, int theType, boolean theIsArray) throws Exception {
        VWParameterDefinition newParameter = new VWParameterDefinition(this, theName, theMode, "", theType, theIsArray);
        this.parameters = (VWParameterDefinition[])this.parametersHandler.addElementToArray(this.parameters, newParameter);
        this.myQueue.setHasChanged(true);
        return newParameter;
    }

    public VWParameterDefinition getParameterDefinition(String theName) throws VWException {
        int i = this.parametersHandler.getIndexFromStringFieldValue(this.parameters, "name", theName);
        if (i == -1) {
            throw new VWException("vw.api.VWOperationDefinitionParameterNotFound", "No parameter found with name equal to {0} in this operation definition.", theName);
        }
        return this.parameters[i];
    }

    public VWParameterDefinition createParameter(VWParameterDefinition theParameter) throws Exception {
        VWParameterDefinition newParameter = new VWParameterDefinition(this, theParameter.getName(), theParameter.getMode(), theParameter.getValue(), theParameter.getDataType(), theParameter.getIsArray());
        newParameter.setDescription(theParameter.getDescription());
        this.parameters = (VWParameterDefinition[])this.parametersHandler.addElementToArray(this.parameters, newParameter);
        this.myQueue.setHasChanged(true);
        return newParameter;
    }

    public void deleteParameter(String theName) throws Exception {
        int i = this.parametersHandler.getIndexFromStringFieldValue(this.parameters, "name", theName);
        if (i == -1) {
            throw new VWException("vw.api.VWOperationDefinitionParameterNotFound", "No parameter found with name equal to {0} in operation definition.", theName);
        }
        this.parametersHandler.deleteElementFromArray(this.parameters, i);
        this.myQueue.setHasChanged(true);
    }

    public VWParameterDefinition[] getParameterDefinitions() throws VWException {
        return (VWParameterDefinition[])this.parametersHandler.getElements(this.parameters);
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) throws VWException {
        this.description = theDescription;
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWOperationDefinitionNullOrEmptyName", "theName is invalid, (null or zero length).");
        }
        if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWOperationDefinitionInvalidOperationName", "Syntax error in operation name \"{0}\", it must begin with a letter, contain only letters, numbers or underscores, length <= {1} and cannot be a name reserved for FileNet internal use (like a name begining with F_, or be a language keyword such as ''if'').", theName, 128);
        }
        VWOperationDefinition existingOp = null;
        try {
            existingOp = this.myQueue.getOperation(theName);
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (existingOp != null) {
            throw new VWException("vw.api.VWOperationDefinitionOpNameAlreadyExists", "theName is invalid, (an operation named {0} already exists in the same queue).", theName);
        }
        this.name = theName;
        this.myQueue.setHasChanged(true);
    }

    protected Object clone() {
        try {
            VWOperationDefinition operationDef = (VWOperationDefinition)super.clone();
            if (this.parameters != null) {
                operationDef.parameters = new VWParameterDefinition[this.parameters.length];
                for (int i = 0; i < this.parameters.length; ++i) {
                    if (this.parameters[i] == null) continue;
                    operationDef.parameters[i] = (VWParameterDefinition)this.parameters[i].clone();
                    operationDef.parameters[i].myContainer = operationDef;
                }
            }
            operationDef.parametersHandler = (VWArrayHandler)this.parametersHandler.clone();
            return operationDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        Hashtable theAttributes;
        this.attributes = theAttributeInfo != null ? (theAttributes = theAttributeInfo.attributes) : null;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWOperationDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        theBuffer.append(INDENT_0 + "<" + "OperationDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.description) + "\"");
        theBuffer.append(">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfParameterDefinition" + ">\n");
        VWParameterDefinition[] parameterList = this.getParameterDefinitions();
        if (parameterList != null && parameterList.length > 0) {
            for (int i = 0; i < parameterList.length; ++i) {
                parameterList[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfParameterDefinition" + ">\n");
        VWAttributeInfo theAttribute = this.getAttributeInfo();
        theAttribute.toXML(theBuffer, INDENT_1);
        theBuffer.append(INDENT_0 + "</" + "OperationDefinition" + ">\n");
    }

    protected Hashtable getAttributes() throws VWException {
        return this.attributes;
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.attributes = theAttributes;
    }

    protected String[] getAttributeNames() throws VWException {
        return VWAttributeInfo.getAttributeNames(this.attributes);
    }

    public VWSession getSession() throws VWException {
        if (this.myQueue != null) {
            return this.myQueue.getSession();
        }
        return null;
    }
}

